------------------------------------------------------------------------------
-- E-Mail composition, Revision 2.0
--
-- composition Script
--
-- This script e-mails a copy of the current composition to a specified address. It 
-- forces a save of the composition before proceeding. Previous settings for the script 
-- are saved in a file called email_composition.last
--
-- written by : Isaac Guenard (izyk@eyeonline.com)
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------------------------------

-- Where is the current fusionScripts folder
lastrun = fusion:MapPath("Scripts:").."comp\\email_composition.last"

-- Laod the last settings used by this script if they are available.
ret, errorMsg = loadfile(lastrun)
if ret then
	ret()
else 
	print("Skipping defaults file "..lastrun.."\nreason : "..("unknown" or errorMsg) )
	default = {}
end

attrs = composition:GetAttrs()

-- get the users input
composition:Lock()
if attrs.COMPS_FileName == "" then
	ret = AskUser("Please Save The composition", {
	{"filename", "FileBrowse", Default=composition:MapPath("Comp:\\")..attrs.COMPS_Name..".comp", Save=true}
	})

	if ret == nil then return end
	composition:Save(ret.filename)
else
	composition:Save(attrs.COMPS_FileName)
end
composition:Unlock()


-- assemble the email
body = attrs.COMPS_Name .. " " .. attrs.COMPN_RenderStartTime .. " " .. attrs.COMPN_RenderEndTime
subject = "composition : "..attrs.COMPS_Name.." - from "..os.getenv("USERNAME").." on " .. os.getenv("COMPUTERNAME")


ret = composition:AskUser("Send composition In Email", {
	{"from", Name="E-Mail From", "Text", Default=(default.from or ""), Lines=1},
	{"to", Name="E-Mail To", "Text", Default=(default.to or ""), Lines=1},
	{"subject", Name="Subject", "Text", Default=subject, Lines=3, Wrap=true},
	{"body", Name="Message", "Text", Default=body, Lines=10}
	})
dump(ret)

-- and send it
if ret then

	mail = fusion:CreateMail()
	mail:AddRecipients(ret.to)
	mail:SetSender(ret.from)
	mail:SetSubject(ret.subject)
	mail:SetBody(ret.body)
	mail:AddAttachment(attrs.COMPS_FileName)
	mail:Send()
	
	print("composition e-mailed to "..ret.to.." at "..os.date())
	
	-- save defaults to file for next time
	file = io.open(lastrun, "w")
	if file then
		file:write("-- Settings from last run of 'email composition.fusionscript'. This file is safe to delete.\n")
		file:write("default = {}\n")
		file:write("default[\"to\"] = [["..ret.to.."]]\n")
		file:write("default[\"from\"] = [["..ret.from.."]]\n")
	end
end
